const { v4: uuidv4 } = require('uuid');
const { runQuery, getQuery } = require('./database');
const crypto = require('crypto');

function generateApiKey() {
  return crypto.randomBytes(32).toString('hex');
}

async function createSession() {
  try {
    const sessionId = uuidv4();
    const apiKey = generateApiKey();

    await runQuery(
      `INSERT INTO sessions (id, api_key, status)
       VALUES (?, ?, ?)`,
      [sessionId, apiKey, 'pending']
    );

    return {
      sessionId,
      apiKey,
      status: 'pending'
    };
  } catch (err) {
    console.error('Error creating session:', err);
    throw err;
  }
}

async function validateApiKey(apiKey, sessionId) {
  try {
    const session = await getQuery(
      'SELECT * FROM sessions WHERE api_key = ? AND id = ?',
      [apiKey, sessionId]
    );

    return session && session.status === 'authenticated';
  } catch (err) {
    console.error('Error validating API key:', err);
    throw err;
  }
}

async function getSessionByApiKey(apiKey) {
  try {
    const session = await getQuery(
      'SELECT * FROM sessions WHERE api_key = ?',
      [apiKey]
    );
    return session;
  } catch (err) {
    console.error('Error getting session by API key:', err);
    throw err;
  }
}

module.exports = {
  createSession,
  validateApiKey,
  getSessionByApiKey,
  generateApiKey
};
