"use strict";
/**
 * Copyright 2024 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Emulation = exports.UserAgentClientHintsCommandSchema = void 0;
/**
 * THIS FILE IS AUTOGENERATED by cddlconv 0.1.7.
 * Run `node tools/generate-bidi-types.mjs` to regenerate.
 * @see https://github.com/w3c/webdriver-bidi/blob/master/index.bs
 */
// eslint-disable-next-line @typescript-eslint/ban-ts-comment
// @ts-nocheck Some types may be circular.
const zod_1 = __importDefault(require("zod"));
exports.UserAgentClientHintsCommandSchema = zod_1.default.lazy(() => Emulation.SetClientHintsOverrideCommandSchema);
var Emulation;
(function (Emulation) {
    Emulation.SetClientHintsOverrideCommandSchema = zod_1.default.lazy(() => zod_1.default.object({
        method: zod_1.default.literal('emulation.setClientHintsOverride'),
        params: zod_1.default.object({
            clientHints: zod_1.default.union([Emulation.ClientHintsMetadataSchema, zod_1.default.null()]),
            contexts: zod_1.default.array(zod_1.default.string()).min(1).optional(),
            userContexts: zod_1.default.array(zod_1.default.string()).min(1).optional(),
        }),
    }));
})(Emulation || (exports.Emulation = Emulation = {}));
(function (Emulation) {
    Emulation.ClientHintsMetadataSchema = zod_1.default.lazy(() => zod_1.default.object({
        brands: zod_1.default.array(Emulation.BrandVersionSchema).optional(),
        fullVersionList: zod_1.default.array(Emulation.BrandVersionSchema).optional(),
        platform: zod_1.default.string().optional(),
        platformVersion: zod_1.default.string().optional(),
        architecture: zod_1.default.string().optional(),
        model: zod_1.default.string().optional(),
        mobile: zod_1.default.boolean().optional(),
        bitness: zod_1.default.string().optional(),
        wow64: zod_1.default.boolean().optional(),
        formFactors: zod_1.default.array(zod_1.default.string()).optional(),
    }));
})(Emulation || (exports.Emulation = Emulation = {}));
(function (Emulation) {
    Emulation.BrandVersionSchema = zod_1.default.lazy(() => zod_1.default.object({
        brand: zod_1.default.string(),
        version: zod_1.default.string(),
    }));
})(Emulation || (exports.Emulation = Emulation = {}));
(function (Emulation) {
    Emulation.SetClientHintsOverrideResultSchema = zod_1.default.lazy(() => zod_1.default.object({}));
})(Emulation || (exports.Emulation = Emulation = {}));
//# sourceMappingURL=webdriver-bidi-ua-client-hints.js.map